% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{agg_to_freq_wide}
\alias{agg_to_freq_wide}
\title{Aggregate data.table and return wide format}
\usage{
agg_to_freq_wide(
  dt,
  date_name = "ref_date",
  frq = c("month", "week", "quarter", "year"),
  id_name = "series_name",
  value_name = "value",
  dt_is_wide = FALSE
)
}
\arguments{
\item{dt}{data.table in long format}

\item{date_name}{name of date column}

\item{frq}{frequency for aggregation, one of `"month"`, `"week"`, `"quarter"`, or `"year"`}

\item{id_name}{name of id column}

\item{value_name}{name of value column}

\item{dt_is_wide}{T/F, is input data `dt` in wide format}
}
\value{
Aggregated data at specificed frequency in wide format
}
\description{
Aggregate a data.table to a specified frequency and return wide format data
}
\examples{
out <- agg_to_freq_wide(fred,frq="quarter")
}
