% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REWarDS.R
\name{fixedWindow}
\alias{fixedWindow}
\title{Fixed window}
\usage{
fixedWindow(
  data,
  window_length = 90,
  dspd_qty,
  strength,
  id,
  serv_date,
  tot_dose_disp = NULL,
  Pt_level = FALSE
)
}
\arguments{
\item{data}{Sample simulated data.
Data may have multiple rows per person (one row per prescription fill).
Required columns include:
1. ID: Patient's unique identification number
2. ServDate: Date on which each prescription was filled.
3. DSPD_QTY: Dispensed quantity: Number of tablets dispensed to patient at each prescription fill.
4. strength: Strength of the tablets dispensed.}

\item{window_length}{The number of days that patients' supply of medication is assumed to
last after each prescription refill. Default= 90 days.}

\item{dspd_qty}{Dispensed quantity: Number of the dispensed tablets to the patient
at each prescription fill.}

\item{strength}{Strength of the tablet dispensed in milligrams.}

\item{id}{Unique patient identification number.}

\item{serv_date}{Date of the prescription fill.}

\item{tot_dose_disp}{Total dose dispensed:
dispensed quantity x strength of the tablets dispensed for
each prescription fill.}

\item{Pt_level}{When TRUE, the estimated daily dose and days' supply are averaged
for the patient.}
}
\value{
fixedWindow returns a dataset called "fixedWindow_result". This data set includes all the
variables originally in the data, plus the following:

tot_dose_disp:                 Total dose dispensed at prescription fill:
                                       dispensed quantity x strength of the tablet
                                       dispensed.

fixed_window_90_wind_Rx_dose:  Daily dose for prescription.

fixed_90_wind_Rx_DS:           Days' supply for prescription.

fixed_90_wind_Pt_dose:         Average daily dose for patient.

fixed_90_wind_Pt_DS:           Average days' supply for patient.
}
\description{
Computes the daily dose and days' supply for prescriptions by assuming a
fixed number of days of exposure (usually 90 days) for all patients,
reflecting the medication supply policies of most medication insurance plans.
}
\examples{
#Patient collects 100 tablets of 5 mg warfarin  on January 3rd,
#and 100 tablets of 7 mg warfarin on February 1st.

#' #Generate a simulated dataset

library(dplyr)
n_patients <- 10
n_records <- 80
data <- data.frame(ID = rep(c(1 : n_patients), each = n_records))
data \%>\%
  group_by(ID) \%>\%
  mutate(ServDate = as.Date('2020/01/01') + abs(round(rnorm(n = 80, 700, 330))),
         DSPD_QTY = abs(round(rnorm(n = 80, 43, 28))),
         strength = abs(round(rnorm(n = 80, 4, 1))))  -> data
data <- as.data.frame(data)

#Assuming window length of 90 days
data_new <- fixedWindow(data, window_length = 90, id = "ID",
                        dspd_qty = "DSPD_QTY", strength = "strength",
                        serv_date = "ServDate", tot_dose_disp =  NULL,
                        Pt_level = TRUE)

#tot_dose_disp = 500mg on January 3rd and 700 mg for February 1st.
#fixed_90_wind_Rx_dose : 500/90 = 5.55 mg  for prescription filled on Jan 3rd;
#                        700/90=7.77 mg for prescription filled on Feb 1st.
#fixed_90_wind_Rx_DS: 90 days for all prescriptions

#pt_level can be set as TRUE to get mean values for each patient
#fixed_90_wind_Pt_dose : (5.55 + 7.77)/2 = 6.66 mg
#fixed_90_wind_Pt_DS: (90 + 90)/2 = 90

}
