% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_value_check.R
\name{missing_value_check}
\alias{missing_value_check}
\title{Missing Value Check}
\usage{
missing_value_check(
  DD.dict,
  DS.data,
  verbose = TRUE,
  non.NA.missing.codes = NA
)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as a list of variables that have non-encoded missing values.}

\item{non.NA.missing.codes}{A user-defined vector of numerical missing value codes (e.g., -9999).}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (A list of variables where a missing value code is not properly encoded).
}
\description{
This function flags variables that have non-encoded missing value codes.
}
\examples{
data(ExampleB)
missing_value_check(DD.dict.B, DS.data.B, non.NA.missing.codes = c(-9999,-4444))

data(ExampleS)
missing_value_check(DD.dict.S, DS.data.S, non.NA.missing.codes = c(-9999,-4444))
}
