% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbacf.R
\name{dbacf}
\alias{dbacf}
\title{Difference-based (auto)covariance/correlation function estimation}
\usage{
dbacf(
  data,
  m,
  d,
  type = c("covariance", "correlation"),
  order = c("second", "first"),
  plot = TRUE,
  ...
)
}
\arguments{
\item{data}{numeric vector or a univariate object of class
\code{\link[stats]{ts}} of length at least \code{2(m + 1)}.}

\item{m}{integer scalar giving the underlying level of dependency.}

\item{d}{numeric vector giving the weights used in difference-based
estimation method. Only pertinent when \code{order=second}.
If missing, the weights \code{d} are calculated according 
to Eqs.(2.12)-(2.14) of \cite{Tecuapetla-Gómez and Munk (2017)}.
When a single value \eqn{d^\ast}{d*} is specified, 
\code{d = rep(}\eqn{d^\ast}{d*}\code{, m + 1)}.}

\item{type}{character string specifying whether covariance (default) 
or correlation must be computed.}

\item{order}{character specifying whether a \code{first} (default)
or a \code{second} difference-based estimate should be employed.}

\item{plot}{logical. If \code{TRUE} (default) the acf is plotted.}

\item{\dots}{further arguments passed to \code{\link{plot.dbacf}}.}
}
\value{
An object of class "dbacf" containing:
\item{acf}{numeric vector of length \code{m + 1} giving estimated
           (auto)covariance-correlation.}
\item{m}{integer giving underlying level of dependency.}
\item{d}{numeric vector containing the weights used to estimate acf.}
\item{acfType}{string indicating whether \code{covariance} or 
               \code{correlation} has been computed.}
\item{n}{integer giving \code{length(data)}.}
\item{series}{string with name of variable \code{data}.}
}
\description{
Computes \emph{and by default plots} the (auto)covariance/correlation function
estimate without pre-estimating the underlying \emph{piecewise constant signal} 
of the observations. To that end, a class of second-order 
\emph{difference-based estimators} is implemented according to Eqs.(2.5)-(2.6)
of \cite{Tecuapetla-Gómez and Munk (2017)}. By default, this function computes
a subclass of estimates with minimal bias according to Eqs.(2.12)-(2.14) of the 
aforementioned paper.
}
\note{
Although the theoretical properties of the methods implemented 
in this function were derived for change point regression with stationary 
\emph{Gaussian} \eqn{m}-dependent errors, these methods have proven robust against 
non-normality of the errors and as efficient as other methods in which 
pre-estimation of an underlying smooth signal is required. For further 
details see Section 6 of \cite{Tecuapetla-Gómez and Munk (2017)}.

The first-order difference-based estimator was implemented following Eqs.(4)-(5)
of \cite{Levine and Tecuapetla-Gómez (2023)}. For the robustness of this estimator
see Section 4 of the just mentioned paper.
}
\examples{
ma2 <- arima.sim(n = 50, model = list(ma = c(0.4, -0.4), order = c(0, 0, 2)), 
                 sd = 0.25)
dbacf(data=ma2, m = 2)
dbacf(data=ma2, m = 2, order="first")
 
}
\references{
Tecuapetla-Gómez, I and Munk, A. (2017). \emph{Autocovariance
estimation in regression with a discontinuous signal and \eqn{m}-dependent errors: A 
difference-based approach}. Scandinavian Journal of Statistics, \bold{44(2)}, 346--368.

Levine, M. and Tecuapetla-Gómez, I. (2023). \emph{Autocovariance 
function estimation via difference schemes for a semiparametric change point model
with \eqn{m}-dependent errors}. Submitted.
}
\seealso{
\code{\link[stats]{acf}}, \code{\link[dbacf]{plot.dbacf}}
}
