% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbacf.R
\name{plot.dbacf}
\alias{plot.dbacf}
\title{Plot autocovariance and autocorrelation functions}
\usage{
\method{plot}{dbacf}(
  x,
  type = "h",
  xlab = "Lag",
  ylab = paste("ACF", ifelse(x$acfType == "covariance", "(cov)", " ")),
  xlim = c(0, x$m + 1),
  main = paste("Series", x$series),
  ltyZeroLine = 3,
  colZeroLine = "blue",
  ...
)
}
\arguments{
\item{x}{an object of class "dbacf".}

\item{type}{what type of plot should be drawn. For possible types see
\code{\link[graphics]{plot}}.}

\item{xlab}{the x label of the plot.}

\item{ylab}{the y label of the plot.}

\item{xlim}{numeric vector of length 2 giving the \code{x} coordinates
range.}

\item{main}{an overall title for the plot.}

\item{ltyZeroLine}{type of line used to draw horizontal line passing at 0.}

\item{colZeroLine}{string indicating color of horizontal line passing at 0.}

\item{\dots}{extra arguments to be passed to plot.}
}
\value{
No return value
}
\description{
This function returns the plot method for objects of class "dbacf".
}
\note{
\code{\link[dbacf]{dbacf}} documents the structure of objects of class "dbacf".
}
\seealso{
\code{\link[stats]{acf}}, \code{\link[dbacf]{dbacf}}.
}
