% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_random_network_exp}
\alias{generate_random_network_exp}
\title{Generate a random DBN and a sampled dataset}
\usage{
generate_random_network_exp(
  n_vars,
  size,
  min_mu,
  max_mu,
  min_sd,
  max_sd,
  min_coef,
  max_coef,
  seed = NULL
)
}
\arguments{
\item{n_vars}{number of desired variables per time-slice}

\item{size}{desired size of the networks}

\item{min_mu}{minimum mean allowed for the variables}

\item{max_mu}{maximum mean allowed for the variables}

\item{min_sd}{minimum standard deviation allowed for the variables}

\item{max_sd}{maximum standard deviation allowed for the variables}

\item{min_coef}{minimum coefficient allowed for the parent nodes}

\item{max_coef}{maximum coefficient allowed for the parent nodes}

\item{seed}{the seed of the experiment}
}
\value{
a list with the original network structure and the sampled dataset
}
\description{
This function generates both a random DBN and a dataset that can be used to 
learn its structure from data. It's intended for experimental use.
}
