% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_modification.R
\name{shift_values}
\alias{shift_values}
\title{Move the window of values backwards in a folded dataset row}
\usage{
shift_values(f_dt, row)
}
\arguments{
\item{f_dt}{a folded dataset}

\item{row}{the index of the row that is going to be processed}
}
\value{
a one row data.table the shifted values
}
\description{
This function moves the values in t_0, t_1, ..., t_n-1 in a folded dataset row to
t_1, t_2, ..., t_n. All the variables in t_0 will be inputed with NAs and the
obtained row can be used to forecast up to any desired point.
}
\examples{
dt <- dbnR::motor
f_dt <- dbnR::fold_dt(dt, size = 2)
s_row <- dbnR::shift_values(f_dt, row = 500)
}
