% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lollipopChart.R
\name{lollipopChart}
\alias{lollipopChart}
\title{Create a lollipop chart}
\usage{
lollipopChart(
  data,
  x,
  y,
  sort = "none",
  bgcol = "white",
  xticks = NULL,
  yticks = NULL,
  xFontSize = 12,
  yFontSize = 12,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  xtitle = NULL,
  xtitleFontSize = 14,
  ytitle = NULL,
  ytitleFontSize = 14,
  title = NULL,
  titleFontSize = 20,
  lineStroke = "maroon",
  lineStrokeWidth = 4,
  circleFill = "lime",
  circleStroke = "lime",
  circleStrokeWidth = 1,
  circleRadius = 10,
  axisCol = "black",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the variables to consider.}

\item{x}{The categorical variable to consider. Will be plotted on the x-axis.}

\item{y}{The numeric variable to consider. Will be plotted on the y-axis.}

\item{sort}{Whether to sort or not the vertical lines. Takes three values
'none' which is the default, 'ascending' or 'descending'.}

\item{bgcol}{The background-color of the SVG output. Defaults to 'white'.}

\item{xticks}{Optional. the number of x-axis ticks to consider.}

\item{yticks}{Optional. The number of y-axis ticks to consider.}

\item{xFontSize}{the font size of the x-axis labels. Defaults to 10.}

\item{yFontSize}{the font size of the y-axis labels. Defaults to 10.}

\item{font}{The font family to consider for the titles. Defaults to
"Verdana, Geneva, Tahoma, sans-serif".}

\item{xtitle}{Optional. The title of the x-axis.}

\item{xtitleFontSize}{The font size of the x-axis title. Defaults to 16.}

\item{ytitle}{Optional. The title of the y-axis.}

\item{ytitleFontSize}{The font size of the y-axis title. Defaults to 16.}

\item{title}{Optional. The title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{lineStroke}{The stroke color of the vertical lines. Defaults to 'maroon'.}

\item{lineStrokeWidth}{The vertical lines stroke's width. Defaults to 4.}

\item{circleFill}{The color of the circles. Defaults to 'lime'.}

\item{circleStroke}{The color of the stroke surrounding the circle. Defaults to 'lime'.}

\item{circleStrokeWidth}{The width of the circles' stroke. Defaults to 1.}

\item{circleRadius}{The radius of the circles. Defaults to 10.}

\item{axisCol}{the color of the x and y axis. It includes the ticks, the labels and titles.
Defaults to 'black'.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
A SVG lollipop chart.
}
\description{
Create a lollipop chart
}
\examples{
library(ggplot2) # needed for the mpg data frame
library(dplyr) # needed for data wrangling

mpg \%>\% group_by(drv) \%>\%
  summarise(median_cty = median(cty)) \%>\%
  lollipopChart(
    x = "drv",
    y = "median_cty",
    sort = "ascending",
    xtitle = "drv variable",
    ytitle = "median cty",
    title = "Median cty per drv"
  )
}
