% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piechart.R
\name{pieChart}
\alias{pieChart}
\title{Create a pie chart}
\usage{
pieChart(
  data,
  value,
  label,
  colorCategory = "Paired",
  innerRadius = 0,
  outerRadius = "auto",
  padRadius = 0,
  padAngle = NULL,
  cornerRadius = 0,
  labelFont = "sans-serif",
  title = NULL,
  titleFontSize = 22,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  bgcol = "white",
  opacity = 1,
  labelHeight = 18,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame to consider.}

\item{value}{The numeric variable to consider.}

\item{label}{The labeling variable to consider.}

\item{colorCategory}{A D3 categorical color scheme, you can find more
here <https://github.com/d3/d3-scale-chromatic#categorical>. Defaults to 'Paired'}

\item{innerRadius}{The size of the inner radius of the pie.
Defaults to 0. Set the inner radius to a higher value to plot
a donut chart.}

\item{outerRadius}{The size of the outer radius of the pie.}

\item{padRadius}{From the D3 official documentation, The pad radius compute
the fixed linear distance separating adjacent arcs, defined as padRadius * padAngle.}

\item{padAngle}{Optional. From the D3 official documentation, the padAngle is used to set the
padding angle between consecutive arcs.}

\item{cornerRadius}{From the D3 official documentation, the value of the corner radius for rounded corners.
If the corner radius is greater than zero, the corners of the arc are rounded
using circles of the given radius. Defaults to 0.}

\item{labelFont}{The font family of the legend. Defaults to 'sans-serif'.}

\item{title}{Optional. The title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{font}{The font family to consider for the titles.
Defaults to "Verdana, Geneva, Tahoma, sans-serif".}

\item{bgcol}{The background color of the SVG. Defaults to "white".}

\item{opacity}{The color opacity of the pie (from 0 to 1). Defaults to 1.}

\item{labelHeight}{The height of the legend. Defaults to 18.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
A SVG pie chart
}
\description{
Create a pie chart
}
\examples{
library(dplyr) # needed for the starwars data frame

# starwars is part of the dplyr data frame
mini_starwars <- starwars \%>\% tidyr::drop_na(mass) \%>\%
  sample_n(size = 5) # getting 5 random values

pieChart(
  data = mini_starwars,
  value = "mass",
  label = "name"
)
}
