% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ddt_lcm}
\alias{predict.ddt_lcm}
\title{Prediction of class memberships from posterior predictive distributions}
\usage{
\method{predict}{ddt_lcm}(object, data, burnin = 3000, ...)
}
\arguments{
\item{object}{a ddt_lcm object}

\item{data}{an NxJ matrix of multivariate binary responses, where
N is the number of individuals, and J is the number of granular items}

\item{burnin}{number of samples to discard from the posterior chain as burn-ins. Default is 3000.}

\item{\dots}{Further arguments passed to each method}
}
\value{
a list of the following named elements:
\describe{
\item{\code{class_assignments}}{an integer vector of individual predicted class memberships
taking values in 1, ..., K}
\item{\code{predictive_probs}}{a N x K matrix of probabilities, where the (i,k)-th element
is the probability that the i-th individual is predicted to belong to class k.}
}
}
\description{
Predict individual class memberships based on posterior predictive distributions.
For each posterior sample, let the class memberships be modal assignments. Then aggregate over
all posterior samples to obtain the most likely assigned classes.
}
\examples{
data(result_diet_1000iters)
burnin <- 500
predicted <- predict(result_diet_1000iters, result_diet_1000iters$data, burnin)
}
