% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_efficiency_fuzzy.R
\name{cross_efficiency_fuzzy}
\alias{cross_efficiency_fuzzy}
\title{Cross efficiency fuzzy analysis}
\usage{
cross_efficiency_fuzzy(datadea,
                       orientation = c("io", "oo"),
                       h = 1,
                       selfapp = TRUE)
}
\arguments{
\item{datadea}{An object of class \code{dea_fuzzy} or \code{deadata_fuzzy}.
If it is of class \code{dea_fuzzy} it must have been obtained with \code{modelfuzzy_guotanaka}.}

\item{orientation}{A string, equal to "io" (input-oriented) or "oo" (output-oriented).}

\item{h}{A numeric vector with the h-levels (in [0,1]).}

\item{selfapp}{Logical. If it is \code{TRUE}, self-appraisal is included in the
average scores of \code{A} and \code{e}.}
}
\value{
A list with the results along with any other necessary information to
replicate the results, such as the name of the model and parameters \code{orientation},
\code{rts}, \code{selfapp} and \code{h}.
}
\description{
Computes the cross-efficiency fuzzy tables from DEA fuzzy data or a
Guo-Tanaka DEA model solution.
The (crisp) relative efficiencies for the case \code{h} = 1 are obtained from
the CCR model (\code{model_multiplier}).
}
\examples{
 data("Guo_Tanaka_2001")
 datadea <- make_deadata_fuzzy(datadea = Guo_Tanaka_2001, 
                               inputs.mL = 2:3, 
                               inputs.dL = 4:5, 
                               outputs.mL = 6:7, 
                               outputs.dL = 8:9)
 result <- cross_efficiency_fuzzy(datadea = datadea, 
                                  h = seq(0, 1, 0.2))
 
}
\references{
Doyle, J.; Green, R. (1994). “Efficiency and Cross Efficiency in DEA: Derivations,
Meanings and the Uses”,  Journal of Operational Research Society, 45(5), 567–578.
\doi{10.2307/2584392}
 
Guo, P.; Tanaka, H. (2001). "Fuzzy DEA: A Perceptual Evaluation Method", Fuzzy
Sets and Systems, 119, 149–160. \doi{10.1016/S0165-0114(99)00106-2}

León, T.; Liern, V.; Ruiz, J.L.; Sirvent, I. (2003). "A Fuzzy Mathematical
Programming Approach to the assessment of efficiency with DEA Models", Fuzzy
Sets Systems, 139(2), 407–419. \doi{10.1016/S0165-0114(02)00608-5}

Sexton, T.R., Silkman, R.H.; Hogan, A.J. (1986). Data envelopment analysis:
critique and extensions. In: Silkman RH (ed) Measuring efficiency: an assessment
of data envelopment analysis, vol 32. Jossey-Bass, San Francisco, pp 73–104.
\doi{10.1002/ev.1441}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
