% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slacks.R
\name{slacks}
\alias{slacks}
\title{Slacks}
\usage{
slacks(deasol)
}
\arguments{
\item{deasol}{Object of class \code{dea} or \code{dea_fuzzy} obtained with some
of the DEA model functions.}
}
\value{
A list with the optimal slacks for each evaluated DMU.
}
\description{
Extract the slacks of the DMUs from a \code{dea} or \code{dea_fuzzy} solution.
}
\examples{
data("Coll_Blasco_2006")
data_example <- make_deadata(Coll_Blasco_2006,
                             ni = 2, 
                             no = 2)
result <- model_multiplier(data_example,
                           orientation = "io", 
                           rts = "crs")
slacks(result)
 
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
