% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_udca.R
\docType{data}
\name{dat_udca}
\alias{dat_udca}
\title{A derived biomarker dataset from a trial of usrodeoxycholic acid}
\format{
A data frame with 169 rows and 12 variables:
\describe{
 \item{id}{subject id}
 \item{trt}{treatment assignment}
 \item{stage}{disease stage}
 \item{bili}{bilirubin level}
 \item{riskscore}{disease risk score}
 \item{futime}{follow up time in days}
 \item{status}{event indicator}
 \item{time}{follow up time in months}
 \item{entry.dt}{enrollment date}
 \item{last.dt}{last visit date}
 \item{BMpos}{biomarker positive indicator (bili>1)}
 \item{group}{subgroup indicator. 1 : trt=0&BMpos=FALSE; 2 : trt=1&BMpos=FALSE; 3 : trt=0&BMpos=TRUE; 4 : trt=1&BMpos=TRUE.}
}
}
\source{
udca data from the R survival package.
  \url{https://CRAN.R-project.org/package=survival}
}
\usage{
dat_udca
}
\description{
dat_udca is derived from the udca data from the R survival package with biomarker variables defined as the baseline bilirubin level > 1.
}
\examples{
data("dat_udca")
}
\keyword{datasets}
