% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsd-class.R
\name{deb_lsd}
\alias{deb_lsd}
\title{A class for pounds, shillings and pence values}
\usage{
deb_lsd(l = double(), s = double(), d = double(), bases = c(20, 12))
}
\arguments{
\item{l}{Numeric vector representing the pounds unit.}

\item{s}{Numeric vector representing the shillings unit.}

\item{d}{Numeric vector representing the pence unit.}

\item{bases}{Numeric vector of length 2 used to specify the bases for the
solidus or s and denarius or d units. Default is \code{c(20, 12)}, which
conforms to the most widely used system of 1 pound = 20 shillings and
1 shilling = 12 pence.}
}
\value{
Returns a vector of class \code{deb_lsd}.
}
\description{
Create a vector of class \code{deb_lsd} to integrate non-decimal currencies
into standardized forms of analysis provided by R.
}
\details{
The \code{deb_decimal} class and the \code{debkeepr} package use the nomenclature of
\href{https://en.wikipedia.org/wiki/£sd}{l, s, and d} to represent the tripartite
system of pounds, shillings, and pence units. The abbreviations derive from
the Latin terms \href{https://en.wikipedia.org/wiki/French_livre}{\emph{libra}},
\href{https://en.wikipedia.org/wiki/Solidus_(coin)}{\emph{solidus}}, and
\href{https://en.wikipedia.org/wiki/Denarius}{\emph{denarius}}. In the 8th century a
\emph{solidus} came to represent 12 \emph{denarii} coins, and, for a time at least,
240 \emph{denarii} were made from one \emph{libra} or pound of silver. The custom of
counting coins in dozens (\emph{solidi}) and scores of dozens (\emph{librae}) spread
throughout the Carolingian Empire and became ingrained in much of Europe.
However, a variety of accounting systems arose at different times that used
\href{https://en.wikipedia.org/wiki/Non-decimal_currency}{other bases} for the
\emph{solidus} and \emph{denarius} units. The \code{bases} attribute of \code{deb_decimal}
vectors makes it possible to specify alternative bases for the \emph{solidus} and
\emph{denarius} units.

The length of \code{l}, \code{s}, and \code{d} must either be all equal, or a vector of
length 1 can be recycled to the length of the other argument(s). See
the \href{https://vctrs.r-lib.org/articles/type-size.html}{vctrs package}
for further details on recycling vectors. In addition, \code{l}, \code{s}, and \code{d}
must either all have no values, resulting in a vector of length 0, or all
possess numeric vectors.
}
\examples{

deb_lsd(5, 3, 8)
deb_lsd(l = c(10, 8, 5),
        s = c(6, 13, 8),
        d = c(8, 4, 10))

# Recycle length 1 vector
deb_lsd(l = c(10, 8, 5),
        s = c(6, 13, 8),
        d = 0)

# Set the bases of the deb_lsd vector
deb_lsd(5, 3, 8, bases = c(60, 16))
deb_lsd(l = c(10, 28, 5),
        s = c(6, 33, 13),
        d = c(8, 42, 10),
        bases = c(60, 16))

# Create a prototype or vector of length 0
deb_lsd()
}
\seealso{
The \code{deb_lsd} class works in concert with the \code{deb_decimal} class, which
represents non-decimal currencies as decimalized values. See
\code{\link[=deb_decimal]{deb_decimal()}}. To represent values with tetrapartite units see
\code{\link[=deb_tetra]{deb_tetra()}}.
}
