% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsd-normalize.R
\name{normalization}
\alias{normalization}
\alias{deb_normalize}
\alias{deb_normalize.default}
\alias{deb_normalize.deb_lsd}
\alias{deb_normalize.numeric}
\alias{deb_normalize.deb_tetra}
\title{Normalize tripartite and tetrapartite values}
\usage{
deb_normalize(x, ...)

\method{deb_normalize}{default}(x, ...)

\method{deb_normalize}{deb_lsd}(x, ...)

\method{deb_normalize}{numeric}(x, bases = c(20, 12), ...)

\method{deb_normalize}{deb_tetra}(x, ...)
}
\arguments{
\item{x}{Either an vector of class \code{deb_lsd}, \code{deb_tetra}, or a numeric
vector of length 3 or 4 representing the values to be normalized.}

\item{...}{Arguments passed on to further methods.}

\item{bases}{Used only if \code{x} is a numeric vector. A Numeric vector of
length 2 or 3 used to specify the bases for the solidus or s, denarius or
d, and optionally the farthing or f units. Default is \code{c(20, 12)}, which
conforms to the most widely used system of 1 pound = 20 shillings and 1
shilling = 12 pence.}
}
\value{
Returns a vector of class \code{deb_lsd} with normalized solidus and
denarius units or a vector of class \code{deb_tetra} with normalized solidus,
denarius, and farthing units.
}
\description{
Normalize tripartite and tetrapartite values values to given bases.
}
\examples{

# Normalize a deb_lsd vector
x <- deb_lsd(12, 93, 78)
x_alt <- deb_lsd(12, 93, 78, bases = c(60, 16))
deb_normalize(x)
deb_normalize(x_alt)

# Normalize a deb_tetra vector
t <- deb_tetra(12, 83, 78, 42)
t_alt <- deb_tetra(12, 83, 78, 42, bases = c(60, 16, 8))
deb_normalize(t)
deb_normalize(t_alt)

# Normalize a numeric vector of length 3
deb_normalize(c(12, 93, 78))
deb_normalize(c(12, 93, 78), bases = c(60, 16))

# Normalize a numeric vector of length 4
# Must provide bases of length 3
deb_normalize(c(12, 93, 78, 42), bases = c(20, 12, 4))
deb_normalize(c(12, 93, 78, 42), bases = c(60, 16, 8))

}
