% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deduped.R
\name{deduped}
\alias{deduped}
\title{Deduplicate a vectorized function to act on \emph{unique} elements}
\usage{
deduped(f)
}
\arguments{
\item{f}{Function that accepts a vector or list as its first input.}
}
\value{
Deduplicated version of \code{f}.
}
\description{
Converts a vectorized function into one that only performs the computations
on unique values in the first argument. The result is then expanded so that
it is the same as if the computation was performed on all elements.
}
\examples{

x <- sample(LETTERS, 10)
x

large_x <- sample(rep(x, 10))
length(large_x)

slow_func <- function(x) {
  for (i in x) {
    Sys.sleep(0.001)
  }
}

system.time({
  y1 <- slow_func(large_x)
})
system.time({
  y2 <- deduped(slow_func)(large_x)
})

all(y1 == y2)
}
