% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deduped_map.R
\name{deduped_map}
\alias{deduped_map}
\title{Apply a function to each \emph{unique} element}
\usage{
deduped_map(.x, .f, ..., .progress = FALSE)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. You must use \code{.x} to refer to the first
argument. Only recommended if you require backward compatibility with
older versions of R.
\item A string, integer, or list, e.g. \code{"idx"}, \code{1}, or \code{list("idx", 1)} which
are shorthand for \verb{\\(x) pluck(x, "idx")}, \verb{\\(x) pluck(x, 1)}, and
\verb{\\(x) pluck(x, "idx", 1)} respectively. Optionally supply \code{.default} to
set a default value if the indexed element is \code{NULL} or does not exist.
}}

\item{...}{Additional arguments passed on to the mapped function.

We now generally recommend against using \code{...} to pass additional
(constant) arguments to \code{.f}. Instead use a shorthand anonymous function:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Instead of
x |> map(f, 1, 2, collapse = ",")
# do:
x |> map(\\(x) f(x, 1, 2, collapse = ","))
}\if{html}{\out{</div>}}

This makes it easier to understand which arguments belong to which
function and will tend to yield better error messages.}

\item{.progress}{Whether to show a progress bar. Use \code{TRUE} to turn on
a basic progress bar, use a string to give it a name, or see
\link[purrr]{progress_bars} for more details.}
}
\value{
A list whose length is the same as the length of the input,
matching the output of \code{\link[purrr:map]{purrr::map()}}.
}
\description{
DEPRECATED as of deduped 0.2.0.

Please use \code{deduped(lapply)()} or \code{deduped(purrr::map)()} instead.
}
\seealso{
\code{\link[=deduped]{deduped()}}
}
