% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_languages.R
\name{available_languages}
\alias{available_languages}
\title{List Supported Languages of the DeepL API Pro}
\usage{
available_languages(auth_key)
}
\arguments{
\item{auth_key}{A string representing the authentication key for the DeepL API Pro. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\description{
\code{available_languages} returns a list of all languages supported by the DeepL API Pro.
}
\details{
To use this function, you must obtain an authentication key by registering for a DeepL API Pro account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Pro}. The function makes an API call to retrieve the 
    list of supported languages and returns them in a structured format.
}
\examples{
\dontrun{
available_languages()
}

}
\references{
\href{https://developers.deepl.com/docs/getting-started/supported-languages}{DeepL API Documentation on Supported Languages}
}
