% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_glossary_entries.R
\name{get_glossary_entries}
\alias{get_glossary_entries}
\title{Retrieve Glossary Entries with the DeepL API Pro}
\usage{
get_glossary_entries(glossary_id, auth_key)
}
\arguments{
\item{glossary_id}{A string specifying the unique ID of the glossary whose entries you want to retrieve.}

\item{auth_key}{A string representing the authentication key for the DeepL API Pro. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\value{
A tibble with two columns representing the source and target language terms. 
    Column names are automatically inferred from the glossary's language pair.
}
\description{
\code{get_glossary_entries} retrieves all term pairs from a specified glossary using the DeepL API Pro.
    For a list of available glossaries, see \code{\link{list_glossaries}}.
}
\details{
Glossaries are custom dictionaries consisting of source-target term pairs. The DeepL API returns these entries 
    as tab-separated values (TSV). This function parses and converts them into a tidy tibble for further analysis.

    To use this function, you must obtain an authentication key by registering for a DeepL API Pro account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Pro}.
}
\examples{
\dontrun{
glossary_id <- "your-glossary-id"
entries <- get_glossary_entries(glossary_id)
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/glossaries#get-glossary-entries}{DeepL API Documentation — Get Glossary Entries}
}
