% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{geo_grobs}
\alias{geo_grobs}
\title{FGDC Geologic Pattern Data}
\format{
A list, where each item corresponds to a geologic pattern stored as a
\link[grid:gTree]{gTree} object as returned by \code{\link[grImport2:grid.picture]{grImport2::pictureGrob()}}.
The names of the list correspond to the pattern codes.
}
\source{
\url{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd.php} via
\url{https://github.com/davenquinn/geologic-patterns}
}
\usage{
geo_grobs
}
\description{
Geologic map and lithology patterns as defined in the \href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd.php}{FGDC Digital Cartographic Standard for Geologic Map Symbolization} by the \href{https://www.usgs.gov/}{U.S. Geological Survey} and the \href{https://ngmdb.usgs.gov/fgdc_gds/index.php}{Geologic Data Subcommittee (GDS)} of the \href{https://www.fgdc.gov/}{Federal Geographic Data Committee (FGDC)}. \code{\link[deeptime:geo_pattern]{deeptime::geo_grob()}} and
\code{\link[deeptime:geo_pattern]{deeptime::geo_pattern()}} should be used to retrieve and modify an individual
pattern as a \link[grid:gTree]{grob} object or \link[grid:patterns]{GridPattern}
object, respectively.
}
\details{
For specific pattern codes, see the "pattern numbers" in the \href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd/fgdc-geolsym-patternchart.pdf}{full pattern chart}.
Daven Quinn has also assembled more accessible documentation of the \href{https://davenquinn.com/projects/geologic-patterns/#pattern-reference}{map patterns/codes}
and \href{https://davenquinn.com/projects/geologic-patterns/#series-600}{lithology patterns/codes}.
\code{\link[rmacrostrat:def_lithologies]{rmacrostrat::def_lithologies()}} can also be used to look up pattern codes
for various lithologies (see the "fill" column). Note that patterns
associated with color variants (e.g., "101-M") are not included but can be
created using \code{\link[deeptime:geo_pattern]{deeptime::geo_grob()}}.

These patterns were originally processed and optimized by Daven Quinn and are
hosted on \href{https://github.com/davenquinn/geologic-patterns/}{GitHub}.
}
\keyword{datasets}
