% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensembles.R
\name{weighted_logLik}
\alias{weighted_logLik}
\title{Tune and evaluate weighted transformation ensembles}
\usage{
weighted_logLik(
  object,
  weights = NULL,
  newdata = NULL,
  convert_fun = function(x, ...) mean(x, ...),
  batch_size = NULL,
  ...
)
}
\arguments{
\item{object}{Object of class \code{"dtEnsemble"}}

\item{weights}{Numeric; weight-vector of length \code{n_ensemble}, if
\code{NULL} the weights are tuned on \code{newdata}}

\item{newdata}{List or data.frame; new data to evaluate or tune the weights
on}

\item{convert_fun}{Function; applied to the log-likelihood values of all
observations.}

\item{batch_size}{Integer; optional, useful if data is too large.}

\item{...}{Further arguments supplied to \code{print.deeptrafo}}
}
\value{
Returns list of ensemble members, average, and ensemble
   log-likelihood converted by \code{convert_fun}
}
\description{
Tune and evaluate weighted transformation ensembles
}
