% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{add_encrypt}
\alias{add_encrypt}
\title{De-identification via hash encryption}
\usage{
add_encrypt(object, ..., hash_key = "", seed = NA)
}
\arguments{
\item{object}{Either a \code{data.frame}, \code{tibble}, or existing \code{DeidentList} pipeline.}

\item{...}{variables to be transformed.}

\item{hash_key}{a random alphanumeric key to control encryption}

\item{seed}{a random alphanumeric to concat to the value being encrypted}
}
\value{
A 'DeidentList' representing the untrained transformation pipeline.
The object contains fields:
\itemize{
\item \code{deident_methods} a list of each step in the pipeline (consisting of \code{variables} and \code{method})
}

and methods:
\itemize{
\item \code{mutate} apply the pipeline to a new data set
\item \code{to_yaml} serialize the pipeline to a '.yml' file
}
}
\description{
\code{add_encrypt()} adds an encryption step to a transformation pipeline.
When ran as a transformation, each specified variable  undergoes replacement
via  an encryption hashing function depending on the \code{hash_key} and \code{seed} set.
}
\examples{

# Basic usage; without setting a `hash_key` or `seed` encryption is poor.
pipe.encrypt <- add_encrypt(ShiftsWorked, Employee)
pipe.encrypt$mutate(ShiftsWorked)

# Once set the encryption is more secure assuming `hash_key` and `seed` are 
# not exposed.
pipe.encrypt.secure <- add_encrypt(ShiftsWorked, Employee, hash_key="hash1", seed="Seed2")
pipe.encrypt.secure$mutate(ShiftsWorked)

}
\keyword{API}
