% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Delayed.R
\name{delayed}
\alias{delayed}
\alias{delayed_fun}
\title{Generates Delayed Version of an Expression}
\usage{
delayed(expr, sequential = FALSE, expect_error = FALSE, timeout = NULL)

delayed_fun(fun, sequential = FALSE, expect_error = FALSE)
}
\arguments{
\item{expr}{expression to delay}

\item{sequential}{if TRUE, never parallelize this task}

\item{expect_error}{if TRUE, pass error to downstream tasks instead of}

\item{timeout}{specify a time limit for computation
halting computation}

\item{fun}{function to delay}
}
\description{
A Delayed version of a function may be called to generate
Delayed objects
}
\examples{
d <- delayed(3 + 4)
d$compute()
adder <- function(x, y) {
  x + y
}
delayed_adder <- delayed_fun(adder)
z <- delayed_adder(3, 4)
z$compute()
}
