% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_eml.R
\name{write_eml}
\alias{write_eml}
\title{Write an EML-formatted metadata document}
\usage{
write_eml(x, file)
}
\arguments{
\item{x}{Object of any class handled by \code{delma}; i.e. \code{tbl_df}, \code{list} or
\code{xml_document}.}

\item{file}{Filename to write to}
}
\value{
Doesn't return anything; called for the side-effect of writing the
specified EML file to disk.
}
\description{
\code{write_eml()} writes a \code{tibble}, \code{list} or \code{xml_document} to an EML file.
Note that EML files always have the file extension \code{.xml}.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
source_file <- system.file("extdata", 
                           "bionet_metadata.Rmd",
                           package = "delma") 
df <- read_md(source_file)
write_eml(df, "example.xml")
\dontshow{
setwd(.old_wd)
}
}
