#' Measured phosphorous of Daphnia and algae
#'
#' A dataset containing phosphorous content in Daphnia and algae. The variables are as follows:
#'
#' \itemize{
#'   \item algae. Phosphorous content in algal food (\%)
#'   \item daphnia. Phosphorous content in \emph{Daphnia} (\%)
#' }
#'
#' @docType data
#' @keywords datasets
#' @name phosphorous
#' @usage data(phosphorous)
#' @format A data frame with 6 rows and 2 variables
#' @source The data were digitized from Sterner and Elser \emph{Ecological Stoichiometry}, page 22, Figure 1.9A.  The original study was DeMott et. al (1998) \emph{Limnol. Oceanogr}. 44:1557.
NULL
