% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phaseplane.R
\name{phaseplane}
\alias{phaseplane}
\title{Phase plane of differential equation.}
\usage{
phaseplane(
  system_eq,
  x_var,
  y_var,
  parameters = NULL,
  x_window = c(-4, 4),
  y_window = c(-4, 4),
  plot_points = 10,
  eq_soln = FALSE,
  precision = 2
)
}
\arguments{
\item{system_eq}{(required) The 1 or 2 dimensional system of equations, written in formula notation as a vector (i.e.  c(dx ~ f(x,y), dy ~ g(x,y)))}

\item{x_var}{(required) x axis variable (used to create the plot and label axes)}

\item{y_var}{(required) y axis variable (used to create the plot and label axes)}

\item{parameters}{(optional) any parameters in the system of equations}

\item{x_window}{(optional) x axis limits.  Must be of the form c(minVal,maxVal).  Defaults to -4 to 4.}

\item{y_window}{(optional) y axis limits.  Must be of the form c(minVal,maxVal). Defaults to -4 to 4.}

\item{plot_points}{(optional) number of points we evaluate on the grid in both directions. Defaults to 10.}

\item{eq_soln}{(optional) TRUE / FALSE - lets you know if you want the code to estimate if there are any equilibrium solutions in the provided window. This will print out the equilibrium solutions to the console.}

\item{precision}{(optional) number of digits to report the equilibrium solution. Increasing the number of digits may report a larger number of possible equilibrium solutions to test.}
}
\value{
A phase plane diagram of system of differential equations
}
\description{
\code{phaseplane} visualizes the vector field for a one or two dimensional differential equation.
}
\examples{
# For a two variable system of differential equations we use the
# formula notation for dx/dt and the dy/dt separately:
system_eq <- c(dx ~ cos(y),
              dy ~ sin(x))
phaseplane(system_eq,x_var='x',y_var='y')

# For a one dimensional system: dy/dt = f(t,y).  In this case the
# xWindow represents time.
# However, the code is structured a little differently.
# Consider dy/dt = -y*(1-y):

system_eq <- c(dt ~ 1,
               dy ~ -y*(1-y))

 phaseplane(system_eq,x_var="t",y_var="y")
\donttest{
# Here is an example to find equilibrium solutions.

 system_eq <- c(dx ~ y+x,
               dy ~ x-y)

 phaseplane(system_eq,x_var='x',y_var='y',eq_soln=TRUE)

# We would expect an equilibrium at the origin,
# but no equilibrium solution was found, but if we narrow the search range:

 phaseplane(system_eq,x_var='x',y_var='y',x_window = c(-0.1,0.1),y_window=c(-0.1,0.1),eq_soln=TRUE)

# Confirm any equilibrium solutions through direct evaluation of the differential equation.


}

}
