% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{fit_optimization}
\alias{fit_optimization}
\title{Unified Optimization-based Estimation (MPS and MLE)}
\usage{
fit_optimization(
  x,
  dist,
  method,
  start,
  lower,
  upper,
  optim_method,
  custom_functions,
  tol_spacing,
  tol_param,
  ties_method,
  ...
)
}
\arguments{
\item{x}{numeric vector of sorted data.}

\item{dist}{character string specifying the distribution.}

\item{method}{character string: "mle" or "mps".}

\item{start}{initial parameter values.}

\item{lower}{lower bounds for parameters.}

\item{upper}{upper bounds for parameters.}

\item{optim_method}{optimization method for \code{\link{optim}}.}

\item{custom_functions}{list of custom distribution functions.}

\item{tol_spacing}{numeric tolerance for spacings/densities.}

\item{tol_param}{numeric tolerance for parameter bounds.}

\item{ties_method}{character string for ties correction method.}

\item{...}{additional arguments for \code{\link{optim}}.}
}
\value{
A list containing parameter estimates, standard errors, objective value,
  log-likelihood, AIC, BIC, KS test results, and convergence information.
}
\description{
Internal function that performs parameter estimation using optimization-based
methods (Maximum Likelihood or Maximum Product Spacing).
}
\keyword{internal}
