% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{makedata}
\alias{makedata}
\title{Create nested data subsets}
\usage{
makedata(data, ...)
}
\arguments{
\item{data}{a data frame, list, tibble or object coercible by
\code{\link{as.data.frame}} to a data frame containing the variables whose
names are given in the factor arguments.}

\item{...}{character strings specifying the names of grouping variables
(factors) in \code{data}. The nesting order follows the argument order.}
}
\value{
A nested list structure where each level corresponds to a factor
level, with the deepest level containing the actual data subsets. If no valid
factors are provided, returns the original data frame with a warning.
}
\description{
A convenient wrapper around \code{nestedFunBuilder} that creates nested
data subsets without applying any function. This is useful for exploring
data structure or preparing data for further analysis.
}
\details{
This function is equivalent to calling \code{nestedFunBuilder} with
\code{.fun = identity}. It provides a simpler interface when you only
need to create nested data structures without applying functions.
}
\examples{
\dontrun{
# require(BiodiversityR)
# data(ifri, package = "BiodiversityR")
# a1 <- makedata(ifri, "forest", "plotID", "species")
# a2 <- makedata(ifri, "species")
# a3 <- makedata(ifri, "forest", "plotID", "species", "size_class")
# identical(makedata(ifri), ifri)
}

}
\seealso{
\code{\link{nestedFunBuilder}} for applying functions to subsets
}
