#' @keywords internal

calculate_lp_distances <- function(groups, p.p, w, ft.lp.weight) {
  combined_group <- do.call(rbind, groups)
  n <- nrow(combined_group)
  D <- matrix(0, n, n)
  for (i in 1:n) {
    for (j in i:n) {
      if (ft.lp.weight == "AbsRoot") w <- sqrt(abs(combined_group[i, ] * combined_group[j, ]))
      diff <- sum(abs(combined_group[i, ] - combined_group[j, ])^p.p * w)^(1/p.p)
      D[i, j] <- diff^2 / 2
      D[j, i] <- D[i, j]
    }
  }
  return(D)
}

calculate_hellinger_distances <- function(groups) {
  combined_group <- do.call(rbind, groups)
  sqrt_combined <- sqrt(abs(combined_group))
  n <- nrow(sqrt_combined)
  D <- matrix(0, n, n)
  for (i in 1:n) {
    for (j in i:n) {
      diff <- sqrt(sum((sqrt_combined[i, ] - sqrt_combined[j, ])^2))
      D[i, j] <- diff^2 / 2
      D[j, i] <- D[i, j]
    }
  }
  return(D)
}

calculate_tf_distances <- function(groups, sigma2) {
  combined_group <- do.call(rbind, groups)
  n <- nrow(combined_group)

  D <- matrix(0, n, n)
  for (i in 1:n) {
    for (j in i:n) {
      diff <- sqrt(sum(abs(combined_group[i, ] - combined_group[j, ])^2 / sigma2))
      D[i, j] <- diff^2 / 2
      D[j, i] <- D[i, j]
    }
  }
  return(D)
}
