% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_log_lognormal.r
\name{sim_log_lognormal}
\alias{sim_log_lognormal}
\title{Simulate data from a normal distribution}
\usage{
sim_log_lognormal(
  n1,
  n2 = NULL,
  ratio,
  cv1,
  cv2 = NULL,
  cor = 0,
  nsims = 1L,
  return_type = "list",
  messages = TRUE
)
}
\arguments{
\item{n1}{(integer: \verb{[2, Inf)})\cr
The sample size(s) of sample 1.}

\item{n2}{(integer: \code{NULL}; \verb{[2, Inf)})\cr
The sample size(s) of sample 2. Set as \code{NULL} if you want to simulate
for the one-sample case.}

\item{ratio}{(numeric: \verb{(0, Inf)})\cr
The assumed population fold change(s) of sample 2 with respect to
sample 1.
\itemize{
\item For one-sample data, \code{ratio} is defined as the geometric mean (GM) of the
original lognormal population distribution.
\item For dependent two-sample data, \code{ratio} is defined by
GM(sample 2 / sample 1) of the original lognormal population distributions.
\itemize{
\item e.g. \code{ratio = 2} assumes that the geometric mean of all paired
ratios (sample 2 / sample 1) is 2.
}
\item For independent two-sample data, the \code{ratio} is defined by
GM(group 2) / GM(group 1) of the original lognormal population distributions.
\itemize{
\item e.g. \code{ratio = 2} assumes that the geometric mean of sample 2 is 2
times larger than the geometric mean of sample 1.
}
}

See 'Details' for additional information.}

\item{cv1}{(numeric: \verb{(0, Inf)})\cr
The coefficient of variation(s) of sample 1 in the original lognormal
data.}

\item{cv2}{(numeric: \code{NULL}; \verb{(0, Inf)})\cr
The coefficient of variation(s) of sample 2 in the original lognormal
data. Set as \code{NULL} if you want to simulate for the one-sample case.}

\item{cor}{(numeric: \code{0}; \verb{[-1, 1]})\cr
The correlation(s) between sample 1 and sample 2 in the original
lognormal data. Not used for the one-sample case.}

\item{nsims}{(Scalar integer: \code{1L}; \verb{[1,Inf)})\cr
The number of simulated data sets. If \code{nsims > 1}, the data is
returned in a list-column of a depower simulation data frame.}

\item{return_type}{(string: \code{"list"}; \code{c("list", "data.frame")})\cr
The data structure of the simulated data. If \code{"list"} (default), a
list object is returned. If \code{"data.frame"} a data frame in tall format
is returned. The list object provides computational efficiency and the
data frame object is convenient for formulas. See 'Value'.}

\item{messages}{(Scalar logical: \code{TRUE})\cr
Whether or not to display messages for pathological simulation cases.}
}
\value{
If \code{nsims = 1} and the number of unique parameter combinations is
one, the following objects are returned:
\itemize{
\item If one-sample data with \code{return_type = "list"}, a list:
\tabular{lll}{
Slot \tab Name \tab Description \cr
1 \tab \tab One sample of simulated normal values.
}
\item If one-sample data with \code{return_type = "data.frame"}, a data frame:
\tabular{lll}{
Column \tab Name \tab Description \cr
1 \tab \code{item} \tab Pair/subject/item indicator. \cr
2 \tab \code{value} \tab Simulated normal values.
}
\item If two-sample data with \code{return_type = "list"}, a list:
\tabular{lll}{
Slot \tab Name \tab Description \cr
1 \tab \tab Simulated normal values from sample 1. \cr
2 \tab \tab Simulated normal values from sample 2.
}
\item If two-sample data with \code{return_type = "data.frame"}, a data frame:
\tabular{lll}{
Column \tab Name \tab Description \cr
1 \tab \code{item} \tab Pair/subject/item indicator. \cr
2 \tab \code{condition} \tab Time/group/condition indicator. \cr
3 \tab \code{value} \tab Simulated normal values.
}
}

If \code{nsims > 1} or the number of unique parameter combinations is greater than
one, each object described above is returned in data frame, located in a
list-column named \code{data}.
\itemize{
\item If one-sample data, a data frame:
\tabular{lll}{
Column \tab Name \tab Description \cr
1 \tab \code{n1} \tab The sample size. \cr
2 \tab \code{ratio} \tab Geometric mean [GM(sample 1)]. \cr
3 \tab \code{cv1} \tab Coefficient of variation for sample 1. \cr
4 \tab \code{nsims} \tab Number of data simulations. \cr
5 \tab \code{distribution} \tab Distribution sampled from. \cr
6 \tab \code{data} \tab List-column of simulated data.
}
\item If two-sample data, a data frame:
\tabular{lll}{
Column \tab Name \tab Description \cr
1 \tab \code{n1} \tab Sample size of sample 1. \cr
2 \tab \code{n2} \tab Sample size of sample 2. \cr
3 \tab \code{ratio} \tab Ratio of geometric means [GM(sample 2) / GM(sample 1)]
or geometric mean ratio [GM(sample 2 / sample 1)]. \cr
4 \tab \code{cv1} \tab Coefficient of variation for sample 1. \cr
5 \tab \code{cv2} \tab Coefficient of variation for sample 2. \cr
6 \tab \code{cor} \tab Correlation between samples. \cr
7 \tab \code{nsims} \tab Number of data simulations. \cr
8 \tab \code{distribution} \tab Distribution sampled from. \cr
9 \tab \code{data} \tab List-column of simulated data.
}
}
}
\description{
Simulate data from the log transformed lognormal distribution (i.e. a normal
distribution). This function handles all three cases:
\enumerate{
\item One-sample data
\item Dependent two-sample data
\item Independent two-sample data
}
}
\details{
Based on assumed characteristics of the original lognormal distribution, data
is simulated from the corresponding log-transformed (normal) distribution.
This simulated data is suitable for assessing power of a hypothesis for the
geometric mean or ratio of geometric means from the original lognormal data.

This method can also be useful for other population distributions which are
positive and where it makes sense to describe the ratio of geometric means.
However, the lognormal distribution is theoretically correct in the sense
that you can log transform to a normal distribution, compute the summary
statistic, then apply the inverse transformation to summarize on the original
lognormal scale.

Let \eqn{GM(\cdot)} be the geometric mean and \eqn{AM(\cdot)} be the
arithmetic mean. For independent lognormal samples \eqn{X_1} and \eqn{X_2}

\deqn{\text{Fold Change} = \frac{GM(X_2)}{GM(X_1)}}

For dependent lognormal samples \eqn{X_1} and \eqn{X_2}

\deqn{\text{Fold Change} = GM\left( \frac{X_2}{X_1} \right)}

Unlike ratios and the arithmetic mean, for equal sample sizes of
\eqn{X_1} and \eqn{X_2} it follows that
\eqn{\frac{GM(X_2)}{GM(X_1)} = GM \left( \frac{X_2}{X_1} \right) =
e^{AM(\ln X_2) - AM(\ln X_1)} = e^{AM(\ln X_2 - \ln X_1)}}.

The coefficient of variation (CV) for \eqn{X} is defined as

\deqn{CV = \frac{SD(X)}{AM(X)}}

The relationship between sample statistics for the original lognormal data
(\eqn{X}) and the natural logged data (\eqn{\ln{X}}) are

\deqn{
\begin{aligned}
AM(X)  &= e^{AM(\ln{X}) + \frac{Var(\ln{X})}{2}} \\
GM(X)  &= e^{AM(\ln{X})} \\
Var(X) &= AM(X)^2 \left( e^{Var(\ln{X})} - 1 \right) \\
CV(X)  &= \frac{\sqrt{AM(X)^2 \left( e^{Var(\ln{X})} - 1 \right)}}{AM(X)} \\
       &= \sqrt{e^{Var(\ln{X})} - 1}
\end{aligned}
}

and

\deqn{
\begin{aligned}
AM(\ln{X})  &= \ln \left( \frac{AM(X)}{\sqrt{CV(X)^2 + 1}} \right) \\
Var(\ln{X}) &= \ln(CV(X)^2 + 1) \\
Cor(\ln{X_1}, \ln{X_2}) &= \frac{\ln \left( Cor(X_1, X_2)CV(X_1)CV(X_2) + 1 \right)}{SD(\ln{X_1})SD(\ln{X_2})}
\end{aligned}
}

Based on the properties of correlation and variance,

\deqn{
\begin{aligned}
Var(X_2 - X_1) &= Var(X_1) + Var(X_2) - 2Cov(X_1, X_2) \\
           &= Var(X_1) + Var(X_2) - 2Cor(X_1, X_2)SD(X_1)SD(X_2) \\
SD(X_2 - X_1)  &= \sqrt{Var(X_2 - X_1)}
\end{aligned}
}

The standard deviation of the differences gets smaller the more positive
the correlation and conversely gets larger the more negative the correlation.
For the special case where the two samples are uncorrelated and each has the
same variance, it follows that

\deqn{
\begin{aligned}
Var(X_2 - X_1) &= \sigma^2 + \sigma^2 \\
SD(X_2 - X_1) &= \sqrt{2}\sigma
\end{aligned}
}
}
\examples{
#----------------------------------------------------------------------------
# sim_log_lognormal() examples
#----------------------------------------------------------------------------
library(depower)

# Independent two-sample data returned in a data frame
sim_log_lognormal(
  n1 = 10,
  n2 = 10,
  ratio = 1.3,
  cv1 = 0.35,
  cv2 = 0.35,
  cor = 0,
  nsims = 1,
  return_type = "data.frame"
)

# Independent two-sample data returned in a list
sim_log_lognormal(
  n1 = 10,
  n2 = 10,
  ratio = 1.3,
  cv1 = 0.35,
  cv2 = 0.35,
  cor = 0,
  nsims = 1,
  return_type = "list"
)

# Dependent two-sample data returned in a data frame
sim_log_lognormal(
  n1 = 10,
  n2 = 10,
  ratio = 1.3,
  cv1 = 0.35,
  cv2 = 0.35,
  cor = 0.4,
  nsims = 1,
  return_type = "data.frame"
)

# Dependent two-sample data returned in a list
sim_log_lognormal(
  n1 = 10,
  n2 = 10,
  ratio = 1.3,
  cv1 = 0.35,
  cv2 = 0.35,
  cor = 0.4,
  nsims = 1,
  return_type = "list"
)

# One-sample data returned in a data frame
sim_log_lognormal(
  n1 = 10,
  ratio = 1.3,
  cv1 = 0.35,
  nsims = 1,
  return_type = "data.frame"
)

# One-sample data returned in a list
sim_log_lognormal(
  n1 = 10,
  ratio = 1.3,
  cv1 = 0.35,
  nsims = 1,
  return_type = "list"
)

# Independent two-sample data: two simulations for four parameter combinations.
# Returned as a list-column of lists within a data frame
sim_log_lognormal(
  n1 = c(10, 20),
  n2 = c(10, 20),
  ratio = 1.3,
  cv1 = 0.35,
  cv2 = 0.35,
  cor = 0,
  nsims = 2,
  return_type = "list"
)

# Dependent two-sample data: two simulations for two parameter combinations.
# Returned as a list-column of lists within a data frame
sim_log_lognormal(
  n1 = c(10, 20),
  n2 = c(10, 20),
  ratio = 1.3,
  cv1 = 0.35,
  cv2 = 0.35,
  cor = 0.4,
  nsims = 2,
  return_type = "list"
)

# One-sample data: two simulations for two parameter combinations
# Returned as a list-column of lists within a data frame
sim_log_lognormal(
  n1 = c(10, 20),
  ratio = 1.3,
  cv1 = 0.35,
  nsims = 2,
  return_type = "list"
)

}
\references{
\insertRef{julious_2004}{depower}

\insertRef{hauschke_1992}{depower}

\insertRef{johnson_1994}{depower}
}
