% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-cross-table.R
\name{ds_cross_table}
\alias{ds_cross_table}
\alias{plot.ds_cross_table}
\alias{ds_twoway_table}
\title{Two way table}
\usage{
ds_cross_table(data, var_1, var_2)

\method{plot}{ds_cross_table}(x, stacked = FALSE, proportional = FALSE, print_plot = TRUE, ...)

ds_twoway_table(data, var_1, var_2)
}
\arguments{
\item{data}{A \code{data.frame} or a \code{tibble}.}

\item{var_1}{First categorical variable.}

\item{var_2}{Second categorical variable.}

\item{x}{An object of class \code{cross_table}.}

\item{stacked}{If \code{FALSE}, the columns of height are portrayed
as stacked bars, and if \code{TRUE} the columns are portrayed as juxtaposed bars.}

\item{proportional}{If \code{TRUE}, the height of the bars is proportional.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{...}{Further arguments to be passed to or from methods.}
}
\description{
Creates two way tables of categorical variables. The tables created can be
visualized as bar plots and mosaic plots.
}
\examples{
# cross table
k <- ds_cross_table(mtcarz, cyl, gear)
k

# bar plot
plot(k)

# stacked bar plot
plot(k, stacked = TRUE)

# proportional bar plot
plot(k, proportional = TRUE)

# returns tibble
ds_twoway_table(mtcarz, cyl, gear)

}
