% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_table.R
\name{freq_table}
\alias{freq_table}
\title{Frequency table}
\usage{
freq_table(
  data,
  x,
  f = "n",
  vals = NULL,
  weights = NULL,
  total = FALSE,
  max = NULL,
  breaks = NULL,
  right = NULL,
  xfirst = NULL,
  xlast = NULL,
  wlast = NULL,
  freq = NULL,
  mass = NULL,
  center = NULL
)
}
\arguments{
\item{data}{a tibble,}

\item{x}{a categorical or numerical series,}

\item{f}{a string containing \code{n} for counts, \code{f} for relative
frequencies, \code{p} for percentages and \code{m} for mass frequencies.
Cumulative series are obtained using the same letters in upper
caps,}

\item{vals}{a character containing letters indicating the values of
the variable that should be returned; \code{x} for the center of the
class, \code{l} and \code{u} for the lower and upper limit of the class,
\code{a} for the range,}

\item{weights}{a series that contain the weights that enable the
sample to mimic the population,}

\item{total}{a logical indicating whether the total should be
returned,}

\item{max}{if the series is a discrete numerical value, this
argument indicates that all the values greater than \code{max}
should be merged in the same modality,}

\item{breaks}{a numerical vector of class limits,}

\item{right}{a logical indicating whether classes should be closed
(\code{right = TRUE}) or open (\code{right = FALSE}) on the right,}

\item{xfirst, xlast, wlast}{see \code{\link[=as_numeric]{as_numeric()}},}

\item{freq}{a series that contains the frequencies (only relevant
if \code{data} is already a frequency table),}

\item{mass}{a series that contains the masses of the variable (only
relevant if \code{data} is already a frequency table),}

\item{center}{a series that contains the center of the class of the
variable (only relevant if \code{data} is already a frequency
table).}
}
\value{
a tibble containing the specified values of \code{vals} and
\code{f}.
}
\description{
Compute the frequency table of a categorical or a numerical series.
}
\examples{
# in table padova, price is a numeric variable, a vector of breaks should be provided
library("dplyr")
padova \%>\% freq_table(price,
                      breaks = c(50, 100, 150, 200, 250, 300, 350, 400),
                      right = TRUE)
# return relative frequencies and densities, and the center value
# of the series and the width of the bin
padova \%>\% freq_table(price,
                      breaks = c(50, 100, 150, 200, 250, 300, 350, 400),
                      right = TRUE, f = "fd", vals = "xa")
# in table wages, wage is a factor that represents the classes
wages \%>\% freq_table(wage, "d")
# a breaks argument is provided to reduce the number of classes
wages \%>\% freq_table(wage, breaks = c(10, 20, 30, 40, 50))
# a total argument add a total to the frequency table
wages \%>\% freq_table(wage, breaks = c(10, 20, 30, 40, 50), total = TRUE)
# ìncome is already a frequency table, the freq argument
# is mandatory
income \%>\% freq_table(inc_class, freq = number)
# the mass argument can be indicated if on column contains the
# mass of the series in each bin. In this case, the center of the
# class are exactly the mean of the series in each bin
income \%>\% freq_table(inc_class, freq = number, mass = tot_inc)
# rgp contains a children series which indicates the number of
# children of the households
rgp \%>\% freq_table(children)
# a max argument can be indicated to merge the unusual high
# values of number of childre
rgp \%>\% freq_table(children, max = 4)
# employment is a non random survey, there is a weights series
# that can be used to compute the frequency table according to the
# sum of weights and not to counts
employment \%>\% freq_table(education)
employment \%>\% freq_table(education, weights = weights)
}
\author{
Yves Croissant
}
\keyword{manip}
