% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_subgroups.R
\name{compile_possible_subgroup_allocation}
\alias{compile_possible_subgroup_allocation}
\title{Compile list of all possible ways to assign levels of the allocation variable to a given set of subgroups}
\usage{
compile_possible_subgroup_allocation(
  subgroup_object,
  fullTree = FALSE,
  maxCalls = 1e+06
)
}
\arguments{
\item{subgroup_object}{A subgrouping object as returned by \code{form_homogeneous_subgroups()}}

\item{fullTree}{Boolean: Enforce full search of the possibility tree, independent of the value of \code{maxCalls}}

\item{maxCalls}{Maximum number of recursive calls in the search tree, to avoid long run times with very large trees}
}
\value{
List of possible allocations; Each allocation is an integer vector of allocation levels that are assigned in that order to the subgroups with given sizes
}
\description{
All information needed to perform this function (primarily the number and size of subgroups plus the levels of the
allocation variable) are contained in and extracted from the subgroup object.
}
