% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{longitudinal_subject_samples}
\alias{longitudinal_subject_samples}
\title{Subject sample list with group and time plus controls}
\format{
An object of class \code{"tibble"}
\describe{
\item{SampleID}{A unique sample identifier.}
\item{SampleType}{Indicates whether the sample is a patient sample, control oder spike-in.}
\item{SubjectID}{The subject identifier.}
\item{Group}{Indicates the treatment group of a subject.}
\item{Week}{Sampling time points in weeks of study.}
\item{Sex}{Subject Sex, Female (F) or Male (M).}
\item{Age}{Subject age.}
\item{BMI}{Subject Body Mass Index.}
\item{SamplesPerSubject}{Look up variable for the number of samples per subject.
This varies as not subject have samples from all weeks.}
}
}
\usage{
data(longitudinal_subject_samples)
}
\description{
A sample list with 9 columns as described below.
There are 3 types of records (rows) indicated by the \code{SampleType} variable.
Patient samples, controls and spike-in standards.
Patient samples were collected over up to 7 time points.
Controls and SpikeIns are QC samples for distribution of the samples on
96 well plates.
}
\author{
Juliane Siebourg
}
\keyword{datasets}
