% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_StackedRuns}
\alias{plot_StackedRuns}
\title{Plot stacked runs}
\usage{
plot_StackedRuns(runs, savePlots = FALSE, separatePlots = FALSE,
  outputName = NULL)
}
\arguments{
\item{runs}{a data.frame with runs per individual (group, id, chrom, nSNP, start, end, length)}

\item{savePlots}{should plots be saved out in files (default) or plotted in
the graphical terminal?}

\item{separatePlots}{should plots for chromosomes be saved out to separate files?}

\item{outputName}{title prefix (the base name of graph, if savePlots is TRUE)}
}
\value{
plot of stacked runs by population and by chromosome (pdf files)
}
\description{
Function to plot stacked runs along the chromosome (signaling presence of large numbers of runs
in specific regions of a chromosome)
Counts on the y-axis, bps on the x-axis (position along the chromosome)
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

# plot runs per animal (interactive)
plot_StackedRuns(runs = runsDF, savePlots = FALSE, outputName = "ROHom")

}
