% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_assignment.R
\name{internal_assignment}
\alias{internal_assignment}
\title{Check the internal assignment of a given classification}
\usage{
internal_assignment(m_bin, p)
}
\arguments{
\item{m_bin}{A matrix. A phytosociological table of 0s (absences) and 1s
(presences), where rows correspond to taxa and columns correspond to
relevés.}

\item{p}{A vector of integer numbers with the partition of the relevés (i.e.,
a k-partition, consisting in a vector with values from 1 to k, with length
equal to the number of columns of \code{m_bin}, ascribing each relevé to one of
the k groups).}
}
\value{
A list with the following components:

\describe{
\item{rel_ambiguous_assign}{A vector containing the names of the relevés
with ambiguous assignment.}
\item{possible_assignments}{A data frame with all the possible
assignments for the ambiguously assigned relevés.}
\item{iap}{The internal assignment precision (IAP), i.e., the proportion
of relevés with unambiguous assignment.}
\item{iaa}{The internal assignment ambiguity (IAA), i.e., the proportion
of relevés with ambiguous assignment (IAA = 1 - IAP).}
}
}
\description{
Given a phytosociological table and a partition of its columns, this function
checks the internal assignment of relevés to groups, based on the  presence
of taxa that are exclusive to each group (or group combination) as defined by
the partition, distinguishing relevés assigned unambiguously to their group
from those for which there is ambiguity.
}
\details{
The function accepts a phytosociological table (\code{m_bin}) and a
k-partition of its columns (\code{p}), and assesses which relevés are assigned
unambiguously to their group and which are not.
The assignment of a relevé to a group is considered unambiguous when
transferring it to another group would alter the pattern of differential
taxa defined by \code{p}. Conversely, if a relevé could be moved to a different
group without changing this pattern, its assignment is considered
ambiguous.
}
\examples{
# Getting the Taxus baccata forests data set
data(taxus_bin)

# Creating some group partitions
groups1 <- rep(c(1, 2, 3), c(3, 11, 19))
set.seed(1)
groups2 <- sample(rep(c(1, 2, 3), c(3, 11, 19)))

# In this case, all relevés are unambiguously assigned to a group
internal_assignment(taxus_bin, groups1)

# In this other case, some relevés could be moved to a different group, as
# their assignment is ambiguous
internal_assignment(taxus_bin, groups2)

}
\author{
Tiago Monteiro-Henriques. E-mail: \email{tmh.dev@icloud.com}.
}
