% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/viz_contributions.R,
%   R/viz_cos2.R
\docType{methods}
\name{viz_contributions}
\alias{viz_contributions}
\alias{viz_contributions-method}
\alias{viz_cos2}
\alias{viz_cos2-method}
\alias{viz_contributions,MultivariateAnalysis-method}
\alias{viz_cos2,MultivariateAnalysis-method}
\title{Visualize Contributions and cos2}
\usage{
viz_contributions(x, ...)

viz_cos2(x, ...)

\S4method{viz_contributions}{MultivariateAnalysis}(
  x,
  ...,
  margin = 2,
  axes = 1,
  sort = TRUE,
  decreasing = TRUE,
  limit = 10,
  horiz = FALSE,
  col = "grey90",
  border = "grey10"
)

\S4method{viz_cos2}{MultivariateAnalysis}(
  x,
  ...,
  margin = 2,
  axes = 1,
  active = TRUE,
  sup = TRUE,
  sort = TRUE,
  decreasing = TRUE,
  limit = 10,
  horiz = FALSE,
  col = "grey90",
  border = "grey10"
)
}
\arguments{
\item{x}{A \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Extra parameters to be passed to \code{\link[graphics:barplot]{graphics::barplot()}}.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{axes}{A \code{\link{numeric}} vector giving the dimensions to be plotted.}

\item{sort}{A \code{\link{logical}} scalar: should the data be sorted?}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort order be decreasing?
Only used if \code{sort} is \code{TRUE}.}

\item{limit}{An \code{\link{integer}} specifying the number of top elements to be
displayed.}

\item{horiz}{A \code{\link{logical}} scalar: should the bars be drawn horizontally
with the first at the bottom?}

\item{col, border}{A \code{\link{character}} string specifying the bars infilling and
border colors.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
plotted?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
plotted?}
}
\value{
\code{viz_contributions()} and \code{viz_cos2()} are called for their side-effects:
they result in a graphic being displayed. Invisibly return \code{x}.
}
\description{
Plots contributions histogram and \eqn{cos^2}{cos2} scatterplot.
}
\details{
The red dashed line indicates the expected average contribution (variables
with a contribution larger than this cutoff can be considered as important
in contributing to the component).
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_quali = "Species")

## Get row contributions
head(get_contributions(X, margin = 1))

## Plot contributions
viz_contributions(X, axes = 1)

## Plot cos2
viz_cos2(X, axes = 1)
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{plot}()},
\code{\link{screeplot}()},
\code{\link{viz_individuals}()},
\code{\link{viz_variables}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
