% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimation}
\alias{estimation}
\title{Estimation}
\usage{
estimation(
  X,
  Y,
  lambdas = NULL,
  lambda_min_ratio = 0.3,
  nlambda = 10,
  a = NULL,
  loss = "lasso",
  tuning = "none",
  perturb = FALSE,
  stop_tol = 1e-05,
  max_iter = 500,
  correlation = FALSE,
  Delta_init = NULL,
  rho = NULL,
  gamma = NULL,
  verbose = FALSE
)
}
\arguments{
\item{X}{The first multivariate normal sample.}

\item{Y}{The second multivariate normal sample.}

\item{lambdas}{Optional parameter - A list of the regularization values to be used within the loss functions.}

\item{lambda_min_ratio}{Optional parameter - Defines the smallest regularization values as this proportion of the largest regularization value. Defaults to 0.3.}

\item{nlambda}{Optional parameter - The number of regularization values considered. Defaults to 10.}

\item{a}{Optional parameter - The thresholding parameter used in SCAD and MCP loss functions. Defaults to 3.7 with SCAD, and 3 with MCP respectively.}

\item{loss}{Optional parameter - The loss function of choice to implement. The function allows for four choices, namely "lasso", "scad", "mcp" and "d-trace". Defaults to "lasso".}

\item{tuning}{Optional parameter - The tuning method selected to determine the optimal value for the regularization parameter. Options are "none", "AIC", "BIC" and "EBIC". Defaults to "none".}

\item{perturb}{Optional parameter - When set to TRUE perturbation as done by the CLIME software to improve performance is implemented. Options are TRUE or FALSE, with the function defaulting to FALSE.}

\item{stop_tol}{Optional parameter - The stop tolerance to determine whether convergence has occurred. Defaults to 1e-5.}

\item{max_iter}{Optional parameter - The maximum number of iterations that can be perform for any one regularization value. Defaults to 100.}

\item{correlation}{Optional parameter - Determines whether the sample correlation matrices should be used in the place of the sample covariance matrices. Choices are TRUE and FALSE with the function defaulting to FALSE.}

\item{Delta_init}{Optional parameter - Allows for the algorithm to provided an initial estimate of the differential network to ease computation.}

\item{rho}{Optional parameter - Allows the user to adjust the ADMM step-size. Defaults to 1.}

\item{gamma}{Optional parameter - Allows the user to adjust the EBIC value when EBIC is the selected tuning method. Defaults to 0.5.}

\item{verbose}{Optional parameter - Allows the user to obtain a summary of the estimation results. Options are TRUE or FALSE, where FALSE indicates the summary is not provided. Defaults to FALSE.}
}
\value{
A list of various outputs, namely:
\itemize{
\item n_X - The number of observations in X.
\item n_Y - The number of observations in Y.
\item Sigma_X - The covariance matrix of X.
\item Sigma_Y - The covariance matrix of Y.
\item loss - The loss function implemented.
\item tuning - The tuning method utilized.
\item lip - The value of the lipschitz constant.
\item iter - The iterations until convergence for each of the regularization values.
\item elapse - The total system time (in seconds) elapsed from initialization to completion of the optimization.
\item lambdas - The regularization parameter values used.
\item sparsity - The level of sparsity of the differential network for each regularization value.
\item path - The set of all differential networks for all regularization values considered.
\item ic - The output obtained from any possible tuning.
\item ic_index - The index at which the tuning is optimized.
\item ic_value - The tuning method optimal value.
\item chosen_lambda_ic - The regularization value that occurs at \strong{ic_index}.
\item loss_index - The index at which the loss function is optimized.
\item loss_value - The loss function optimal value.
\item chosen_lambda_loss - The regularization value that occurs at \strong{loss_index}.
}
}
\description{
This function performs alternating direction method of multipliers optimization
for a variety of loss functions to estimate the differential network given
two samples of multivariate normal data.
}
\examples{
data <- data_generator(n = 100, p = 50, seed = 123)
X <- data$X
Y <- data$Y
result <- estimation(X,Y)
}
