% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dineq_change_rb.R
\name{dineq_change_rb}
\alias{dineq_change_rb}
\title{Decomposition of the change in inequality}
\usage{
dineq_change_rb(formula1, weights1 = NULL, data1, formula2, weights2 = NULL,
  data2)
}
\arguments{
\item{formula1}{an object of class "formula" (or one that can be coerced to that class)
for the first year/dataset: a symbolic description of the model to be fitted in the ordinary
least squares regression.}

\item{weights1}{an optional vector of weights to be used in the fitting process. Should be
NULL or a numeric vector. Should be inside selected data frame in the function and between
quotation marks.}

\item{data1}{a data frame containing the variables for the first year/dataset in the model.}

\item{formula2}{an object of class "formula" (or one that can be coerced to that class)
for the first year/dataset: a symbolic description of the model to be fitted in the ordinary
least squares regression.}

\item{weights2}{an optional vector of weights to be used in the fitting process. Should be
NULL or a numeric vector. Should be inside selected data frame in the function and between
quotation marks.}

\item{data2}{a data frame containing the variables for the first year/dataset in the model.}
}
\value{
a list with the results of the decomposition and the parts used for the
decomposition, containing the following components:
   \item{attention}{optional note on the difference in the input.}
   \item{variance_logincome}{the values of the variance of log income of both years/datasets and
   difference between both.}
   \item{decomposition_inequality}{the (relative) decomposition of the inequality of both
   years/datasets into the different variables. See function 'rb_decomp'.}
   \item{decomposition_change_absolute}{decomposition of the change in the variance
   of log income into the different variables and residual split into price and quantity
   effects. Adds up to the absolute change in variance of log income.}
   \item{decomposition_change_relative}{decomposition of the change in the variance of log
   income into the different variables and residual split into price and quantity effects.
   Adds up to 100 percent.}
   \item{notes}{number of zero or negative observations in both data sets/years. The function
   uses a logarithmic transformation of x as input for the regression. Therefore these
   observations are deleted from the analysis}
}
\description{
Decomposition of the change in (income) inequality into multiple characteristics,
divided by a price and a quantity effect.
}
\details{
This function uses a multivariate regression-based decomposition method. Multiple
characteristics can be added to the function in order to calculate the contribution of each
individual variable (including the residual) to the change of the inequality. For instance
socio-economic,  demographic and geographic characteristics (such as age, household composition,
gender, region, education) of the household or the individual can be added.

The change decomposition is divided into a price and a quantity effect for each characteristic.
The quantity effect is caused by changes in the relative size of subgroups (for instance: a higher
percentage of elderly households). The price effect is caused by a change in the influence of the
characteristic on the dependent variable (for instance a higher income for the elderly
households).

It uses a logarithmic transformation of the values of the dependent variable. Therefore it
cannot handle negative or zero values. Those are excluded from the computation in this function.

The decomposition can only be used on the variance of log income.

The main difference with the decomposition of the change of the mean log deviation is that
multiple characteristics can be analyzed at the same time. While the decomposition function
only analyze one characteristic at the same time.

The function uses two datasets for both years to compare. Pay attention that characteristics
should be the same (although can be named differently) and in the same order in the formula.
}
\examples{
#Decomposition of the change in income inequality into 4 variables using the Mexican Income
#data set
data(mex_inc_2008)
inequality_change <- dineq_change_rb(formula1=income~hh_structure+education+domicile_size+age_cat,
weights1="factor",data1=mex_inc_2008, formula2=income~hh_structure+education+
domicile_size+age_cat, weights2="factor",data2=mex_inc_2016)

#selection of output: change in variance of log income decomposed in variables split into price
#and quantity effect and residual.
inequality_change["decomposition_change_absolute"]

#selection of output: relatieve change in variance of log income decomposed in variables split
#into price and quantity effect and residual. Because of negative change in variance of log
#income, the negative contributuon of education (quantity) becomes a positive number.
inequality_change["decomposition_change_relative"]

}
\references{
Yun, M.-S. (2006) Earnings Inequality in USA, 1969–99: Comparing Inequality Using Earnings
Equations, \emph{Review of Income and Wealth}, 52 (1): p. 127–144.

Fields, G. (2003) Accounting for income inequality and its change: a new method, with
application to the distribution of earnings in the United States, \emph{Research in Labor
Economics}, 22, p. 1–38.

Brewer M., and L. Wren-Lewis (2016) Accounting for Changes in Income Inequality:
Decomposition Analyses for the UK, 1978–2008. \emph{Oxford Bulletin of economics and
statistics}, 78 (3), p. 289-322,
}
\seealso{
\code{\link{dineq_rb}}
}
