% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEstimation.R
\name{estSurv}
\alias{estSurv}
\title{Estimated Survival Function}
\usage{
estSurv(haz)
}
\arguments{
\item{haz}{Estimated hazard rates ("numeric vector")}
}
\value{
Estimated probabilities of survival ("numeric vector")
}
\description{
Estimates the survival function S(T = t|x) based on estimated hazard rates.
The hazard rates may or may not depend on covariates. The covariates have to
be equal across all estimated hazard rates. Therefore the given hazard rates
should only vary over time.
}
\details{
The argument \emph{haz} must be given for all intervals [a_0, a_1), [a_1,
a_2), ..., [a_{q-1}, a_q), [a_q, Inf).
}
\note{
It is assumed that all time points up to the last 
theoretical interval [a_q, Inf) are available. If not already present, 
these can be added manually.
}
\examples{


# Example unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
subUnempDur <- UnempDur [1:100, ]

# Convert to long format
UnempLong <- dataLong(dataShort = subUnempDur, timeColumn = "spell", eventColumn = "censor1")
head(UnempLong)

# Estimate binomial model with logit link
Fit <- glm(formula = y ~ timeInt + age + logwage, data=UnempLong, family = binomial())

# Estimate discrete survival function given age, logwage of first person
hazard <- predict(Fit, newdata = subset(UnempLong, obj == 1), type = "response")
SurvivalFuncCondX <- estSurv(c(hazard, 1))
SurvivalFuncCondX

}
\references{
\insertRef{tutzModelDisc}{discSurv}
}
\seealso{
\code{\link{estMargProb}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{survival}
