% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvAuxiliary.R
\name{weightsLtoT}
\alias{weightsLtoT}
\title{Compute Subdistribution Weights}
\usage{
weightsLtoT(
  dataShortTrain,
  dataShortTest,
  timeColumn,
  eventColumns,
  eventFocus
)
}
\arguments{
\item{dataShortTrain}{Learning data in short format ("class data.frame").}

\item{dataShortTest}{Test data in short format ("class data.frame").}

\item{timeColumn}{Character specifying the column name of the observed event times ("character vector"). 
It is required that the observed times are discrete ("integer vector").}

\item{eventColumns}{Character vector specifying the column names of the event indicators ("logical vector")(excluding censoring events). 
It is required that a 0-1 coding is used for all events. The algorithm treats row sums of zero of all event columns as censored.}

\item{eventFocus}{Column name of the event of interest, which corresponds to the type 1 event ("character vector").}
}
\value{
Subdstribution weights for the test data in long format using the estimated 
censoring survival function from the learning data ("numeric vector"). The length of the 
vector is equal to the number of observations of the long test data.
}
\description{
Function to compute new subdistribution weights for a test data set based on the estimated 
censoring survival function from a learning data set
}
\examples{
####################
# Data preprocessing

# Example unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
selectInd1 <- 1:100
selectInd2 <- 101:200
trainSet <- UnempDur[which(UnempDur$spell \%in\% (1:10))[selectInd1], ]
valSet <- UnempDur[which(UnempDur$spell \%in\% (1:10))[selectInd2], ]  

# Convert to long format
trainSet_long <- dataLongSubDist(dataShort = trainSet, timeColumn = "spell", 
eventColumns = c("censor1", "censor4"), eventFocus = "censor1")
valSet_long <- dataLongSubDist(dataShort = valSet, timeColumn = "spell", 
eventColumns = c("censor1", "censor4"), eventFocus = "censor1")

# Compute new weights of the validation data set 
valSet_long$subDistWeights <- weightsLtoT(trainSet, valSet, timeColumn = "spell", 
eventColumns = c("censor1", "censor4"), eventFocus = "censor1")

# Estimate continuation ratio model with logit link
glmFit <- glm(formula = y ~ timeInt + age + logwage, data = trainSet_long, 
family = binomial(), weights = trainSet_long$subDistWeights)

# Calculate predicted discrete hazards 
predHazards <- predict(glmFit, newdata = valSet_long, type = "response")

# Calibration plot 
calibrationPlot(predHazards, testDataLong = valSet_long, weights = valSet_long$subDistWeights)

}
\references{
\insertRef{bergerSubdist}{discSurv}
}
\seealso{
\code{\link{dataLongSubDist}}, \code{\link{calibrationPlot}}
}
\author{
Moritz Berger \email{moritz.berger@imbie.uni-bonn.de} \cr \url{https://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
\keyword{discrete}
\keyword{hazards}
\keyword{subdistribution}
