% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{beckham_1929}
\alias{beckham_1929}
\title{Beckham (1929) data}
\format{
A tibble with 16 rows and 5 variables.
}
\source{
\href{https://www.discovr.rocks/csv/beckham_1929.csv}{www.discovr.rocks/csv/beckham_1929.csv}
}
\usage{
beckham_1929
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
During my psychology degree I spent a lot of time reading about the civil rights movement in the USA. Instead of reading psychology,
I read about Malcolm X and Martin Luther King Jr. For this reason I find Beckham's 1929 study of black Americans
a fascinating historical piece of research. Beckham was a black American who founded the psychology laboratory
at Howard University, Washington, DC and his wife Ruth was the first black woman ever to be awarded a PhD
(also in psychology) at the University of Minnesota. To put some context on the study, it was published
36 years before the Jim Crow laws were finally overthrown by the Civil Rights Act of 1964, and in a time when
black Americans were segregated, openly discriminated against and victims of the most abominable violations of
civil liberties and human rights (I recommend James Baldwin's superb The fire next time for an insight into the times).
The language of the study and the data from it are an uncomfortable reminder of the era in which it was conducted.

Beckham sought to measure the psychological state of 3443 black Americans with three questions. He asked them to
answer yes or no to whether they thought black Americans were happy, whether they personally were happy as a black
American, and whether black Americans should be happy. Beckham did no formal statistical analysis of his data
(Fisher's article containing the popularized version of the chi-square test was published only 7 years earlier
in a statistics journal that would not have been read by psychologists).
I love this study, because it demonstrates that you do not need elaborate methods to answer important and far-reaching questions;
with just three questions, Beckham told the world an enormous amount about very real and important psychological and sociological phenomena.
These are the data from that study. The data contains the following variables:
\itemize{
\item \strong{profession}: Profession of respondents
\item \strong{response}: response to the question as yes or no
\item \strong{happy}: frequencies of reponses to a question about whether black Americans were happy
\item \strong{you_happy}: frequencies of reponses to a question about whether they personally were happy
\item \strong{should_be_happy}: frequencies of reponses to a question about whether black Americans should be happy
}
}
\references{
\itemize{
\item Beckham, A. S. (1929). Is the Negro happy? A psychological analysis. \emph{Journal of Abnormal and Social Psychology}, 24, 186–190. \doi{10.1037/h0072938}
}
}
\keyword{datasets}
