% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{tuk_2011}
\alias{tuk_2011}
\title{Tuk et al. (2011) data}
\format{
A tibble with 102 rows and 3 variables
}
\source{
\href{https://www.discovr.rocks/csv/tuk_2011.csv}{www.discovr.rocks/csv/tuk_2011.csv}
}
\usage{
tuk_2011
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Visceral factors that require us to engage in self control (such as a filling bladder) can affect our inhibtory
abilities in unrelated domains. In a fascinating study by Tuk, Trampe, and Warlop (2011) participants were given
five cups of water: one group was asked to drink them all, whereas another was asked to take a sip from each.
This manipulation led one group to have full bladders and the other group relatively empty (urgency).
Later on, these participants were given eight trials on which they had to choose between a small financial
reward that they would receive soon (SS) or a large financial reward for which they would wait longer (LL).
They counted how many trials participants choose the LL reward as an indicator of inhibitory control (ll_sum). The data contains three variables:
\itemize{
\item \strong{id}: participant ID
\item \strong{urgency}: whether participants were in a high urination urgency condition (they drank everything) or a low urgency condition (they took sips of water)
\item \strong{ll_sum}: the total number of LL rewards
}
}
\references{
\itemize{
\item Tuk, M. A., Trampe, D., & Warlop, L. (2011). Inhibitory spillover: increased urination urgency facilitates impulse control in unrelated domains. \emph{Psychological Science}, 22, 627–633. \doi{10.1177/0956797611404901}
}
}
\keyword{datasets}
