% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null.test.R
\name{null.test}
\alias{null.test}
\title{Testing a null hypothesis on multidimensional data.}
\usage{
null.test(
  data,
  replicates = 100,
  null.distrib,
  null.args = NULL,
  null.cor = NULL,
  null.scree = NULL,
  alter = "two-sided",
  scale = FALSE,
  ...
)
}
\arguments{
\item{data}{a \code{dispRity} object.}

\item{replicates}{the number of replicates for the test (default = \code{100}).}

\item{null.distrib}{one or more distribution functions to generate the null model to be passed to \code{\link{space.maker}}.}

\item{null.args}{any additional distribution arguments to be passed to \code{\link{space.maker}} (see \code{arguments} within; \code{default = NULL}).}

\item{null.cor}{an additional correlation matrix to be passed to \code{\link{space.maker}} (see \code{cor.matrix} within; \code{default = NULL}).}

\item{null.scree}{an additional vector of variance per axis (equivalent to \link[stats]{screeplot} output); \code{default = NULL}).}

\item{alter}{the type of alternative hypothesis (H1) as used in \code{\link[ade4]{randtest}} (\code{default = "two-sided"}).}

\item{scale}{whether to scale the simulated and the observed data.}

\item{...}{optional arguments to be passed to \code{\link[ade4]{as.randtest}}.}
}
\description{
Testing the difference between the observed disparity and disparity under a null model.
}
\examples{
## Load the Beck & Lee 2014 data
data(BeckLee_mat50)
## Calculating the disparity as the ellipsoid volume
obs_disparity <- dispRity(BeckLee_mat50, metric = ellipsoid.volume)
## Testing against normal distribution
results <- null.test(obs_disparity, replicates = 100, null.distrib = rnorm)
results ; plot(results)

## Running the test on multiple subsets (may take some time!)
## Generating the subsets
groups <- as.data.frame(matrix(data = c(rep(1, 12), rep(2, 13), rep(3, 12),
     rep(4, 13)), dimnames = list(rownames(BeckLee_mat50))), ncol = 1)
customised_subsets <- custom.subsets(BeckLee_mat50, groups)
## Bootstrapping the data
bootstrapped_data <- boot.matrix(customised_subsets, bootstraps = 100)
## Calculating variances of each dimension
sum_variances <- dispRity(bootstrapped_data, metric = c(sum, variances))
## Testing against normal distribution
results <- null.test(sum_variances, replicates = 100, null.distrib = rnorm)
summary(results) ; plot(results)

}
\references{
Diaz, S., Kattge, J., Cornelissen, J.H., Wright, I.J., Lavorel, S., Dray, S., Reu, B., Kleyer, M., Wirth, C., Prentice, I.C. and Garnier, E., \bold{2016}. The global spectrum of plant form and function. Nature, 529(7585), pp.167-171.
}
\seealso{
\code{\link{space.maker}}, \code{\link{test.dispRity}}
}
\author{
Thomas Guillerme
}
