% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.tree.R
\name{slice.tree}
\alias{slice.tree}
\title{Time slicing a tree.}
\usage{
slice.tree(tree, age, model, FAD, LAD, keep.all.ancestors = FALSE)
}
\arguments{
\item{tree}{A \code{phylo} object with a \code{root.time} element.}

\item{age}{A single \code{numeric} value indicating where to perform the slice.}

\item{model}{One of the following models: \code{"acctran"}, \code{"deltran"}, \code{"random"}, \code{"proximity"}, \code{"equal.split"} or \code{"gradual.split"}. Is ignored if \code{method = "discrete"}. See \code{\link{chrono.subsets}} for the models description.}

\item{FAD, LAD}{The first and last occurrence data.}

\item{keep.all.ancestors}{Optional, whether to also include the ancestors of the tree slice (\code{TRUE}) or just the ones linking the elements present at the slice (\code{FALSE}; default)}
}
\description{
Time slicing through a phylogenetic tree.
}
\examples{
set.seed(1)
## Generate a random ultrametric tree
tree <- rtree(20)

## Add some node labels
tree$node.label <- letters[1:19]

## Add its root time
tree$root.time <- max(tree.age(tree)$ages)

## Slice the tree at age 1.5
tree_slice <- slice.tree(tree, age = 1.5, "deltran")

## The slice at age 0.5 but keeping all the ancestors
deep_slice <- slice.tree(tree, age = 0.5, "deltran",
                            keep.all.ancestors = TRUE)

## Visualising the trees
old_par <- par(mfrow = c(2,2))
plot(ladderize(tree), main = "full tree"); axisPhylo()
abline(v =  tree$root.time - 1.5)
plot(ladderize(tree_slice), main = "tree slice"); axisPhylo()
plot(ladderize(deep_slice), main = "slice with ancestors"); axisPhylo()

par(old_par)

}
\references{
Guillerme T. & Cooper N. \bold{2018}. Time for a rethink: time sub-sampling methods in disparity-through-time analyses. Palaeontology. DOI: 10.1111/pala.12364.
}
\seealso{
\code{paleotree::timeSliceTree}, \code{\link{chrono.subsets}}.
}
\author{
Thomas Guillerme
}
