% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentum_stats.R
\name{momentum_stats}
\alias{momentum_stats}
\title{Stats of Dissimilarity Data Frame}
\usage{
momentum_stats(df = NULL)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, or \code{\link[=momentum_dtw]{momentum_dtw()}}. Default: NULL}
}
\value{
data frame
}
\description{
Takes the output of \code{\link[=distantia]{distantia()}} to return a data frame with one row per time series with the stats of its dissimilarity scores with all other time series.
}
\examples{
tsl <- tsl_simulate(
  n = 5,
  irregular = FALSE
  )

df <- distantia(
  tsl = tsl,
  lock_step = TRUE
  )

df_stats <- distantia_stats(df = df)

df_stats

}
\seealso{
Other momentum_support: 
\code{\link{momentum_aggregate}()},
\code{\link{momentum_boxplot}()},
\code{\link{momentum_model_frame}()},
\code{\link{momentum_spatial}()},
\code{\link{momentum_to_wide}()}
}
\concept{momentum_support}
