% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi_cost_path_sum.R
\name{psi_cost_path_sum}
\alias{psi_cost_path_sum}
\title{Sum of Distances in Least Cost Path}
\usage{
psi_cost_path_sum(path = NULL)
}
\arguments{
\item{path}{(required, data frame) least cost path produced by \code{\link[=psi_cost_path]{psi_cost_path()}}. Default: NULL}
}
\value{
numeric value
}
\description{
Demonstration function to sum the distances of a least cost path.
}
\examples{
#distance metric
d <- "euclidean"

#simulate two irregular time series
x <- zoo_simulate(
  name = "x",
  rows = 100,
  seasons = 2,
  seed = 1
)

y <- zoo_simulate(
  name = "y",
  rows = 80,
  seasons = 2,
  seed = 2
)

if(interactive()){
  zoo_plot(x = x)
  zoo_plot(x = y)
}

#distance matrix
dist_matrix <- psi_distance_matrix(
  x = x,
  y = y,
  distance = d
)

#orthogonal least cost matrix
cost_matrix <- psi_cost_matrix(
  dist_matrix = dist_matrix
)

#orthogonal least cost path
cost_path <- psi_cost_path(
  dist_matrix = dist_matrix,
  cost_matrix = cost_matrix
)

#sum of distances in cost path
psi_cost_path_sum(
  path = cost_path
)
}
\seealso{
Other psi_demo: 
\code{\link{psi_auto_distance}()},
\code{\link{psi_auto_sum}()},
\code{\link{psi_cost_matrix}()},
\code{\link{psi_cost_path}()},
\code{\link{psi_distance_lock_step}()},
\code{\link{psi_distance_matrix}()},
\code{\link{psi_equation}()}
}
\concept{psi_demo}
