set.seed(20250522)

fcl <- function(need, covlist)
  distfreereg:::fill_covariance_list(need = need, covariance_list = covlist,
                                     matsqrt_tol = distfreereg:::default_distfreereg_tol()[["matsqrt_tol"]],
                                     solve_tol = distfreereg:::default_distfreereg_tol()[["solve_tol"]])

n <- 1e2
Sig <- rWishart(1, df = n, Sigma = diag(n))[,,1]
P <- fcl(need = "P", list(Sigma = Sig))[["P"]]
SqrtSigma <- fcl(need = "SqrtSigma", list(P = P))[["SqrtSigma"]]
Q <- fcl(need = "Q", list(SqrtSigma = SqrtSigma))[["Q"]]
Sig_2 <- fcl(need = "Sigma", list(SqrtSigma = SqrtSigma))[["Sigma"]]
Sig_3 <- fcl(need = "Sigma", list(Q = Q))[["Sigma"]]
P_2 <- fcl(need = "P", list(Q = Q))[["P"]]
P_3 <- fcl(need = "P", list(SqrtSigma = SqrtSigma))[["P"]]


tryCatch(distfreereg:::model2method("hello"), error = function(e) warning(e))

tryCatch(distfreereg::rejection("hello"), error = function(e) warning(e))

mats <- rWishart(n = 2, df = 5, Sigma = diag(5))
mat_list <- list(mats[,,1], mats[,,2])
mat_list_sq <- distfreereg:::covsquare(mat_list)
stopifnot(isTRUE(all.equal(mat_list_sq, lapply(mat_list, crossprod))))

vec <- rexp(5)
vec_sq <- distfreereg:::matsquare(vec)
stopifnot(isTRUE(all.equal(vec_sq, vec * vec)))


err_dist_args <- distfreereg:::create_err_dist_args_default(
  err_dist_fun_formals = c("Sigma", "SqrtSigma", "P", "Q"),
  cov_args = c("Sigma", "SqrtSigma", "P", "Q"),
  reps = 10, n = 1e2, true_covariance = list(Sigma = Sig, P = P, Q = Q,
                                             SqrtSigma = SqrtSigma))
names(err_dist_args)


distfreereg:::matsqrt(matrix(4))

tryCatch(distfreereg:::covprod(cov = array(4), mat = matrix(1)),
         error = function(e) warning(e))

tryCatch(distfreereg:::scale_to_01(matrix(rep(1, 5)), one_value = "fail"),
         error = function(e) warning(e))
