% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disto_methods.R, R/disto_package.R
\docType{package}
\name{disto}
\alias{disto}
\alias{disto}
\alias{disto-package}
\alias{disto-package}
\title{Constructor for class 'disto'}
\usage{
disto(..., backend = "dist")
}
\arguments{
\item{...}{Arguments for a backend. See details}

\item{backend}{(string) Specify a backend. Currently supported: 'dist'}
}
\value{
Object of class 'disto' which is a thin wrapper on a list
}
\description{
Create mapping to data sources storing distances(symmetric),
  dissimilarities(non-symmetric), similarities and so on

Provides a high level API to interface over backends storing
  distance, dissimilarity, similarity matrices with matrix style extraction,
  replacement and other utilities. Currently, in-memory dist object backend
  is supported.
}
\details{
This is a wrapper to create a 'disto' handle over different backends
  storing distances, dissimilarities, similarities etc with minimal data
  overhead like a database connection. The following named arguments are
  required to set-up the backend:

  \itemize{

  \item \strong{dist}:

  \itemize{

  \item objectname: Object of the class 'dist' or the name of the object as a
  'string'.

  \item env: Environment where the object exists. When this is missing, its
  assumed to be parent environment.

  }

  }
}
\examples{
temp <- stats::dist(iris[,1:4])
dio   <- disto(objectname = "temp")
dio
unclass(dio)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/talegari/disto}
  \item Report bugs at \url{https://github.com/talegari/disto/issues}
}

}
\author{
Srikanth KS
}
