% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_package.R
\name{use_distance}
\alias{use_distance}
\title{Adds a distance function to the package}
\usage{
use_distance(distance_name)
}
\arguments{
\item{distance_name}{A character string specifying the name of the distance
that the user aims at implementing.}
}
\value{
Nothing.
}
\description{
This function adds a distance function to the package. It first
creates the \verb{R/\{distance_name\}Distance.R} file with the R wrapper function
for the distance function. It then creates the
\verb{src/\{distance_name\}Distance.cpp} file with the C++ implementation of the
distance function. It finally opens the latter file in the default editor.
The user will be able to implement the desired distance function in a way
compatible with the \strong{RcppParallel} workflow.
}
\examples{
\donttest{
use_distance("euclidean")
}
}
